unit Form;

{$I delphi.inc}

interface

uses
  Windows, Messages, SysUtils, {$IFDEF D6OR7}Variants, {$ENDIF}Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, jsintf;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    FEngine: TJSEngine;
    FScript: TJSScript;
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  FEngine := TJSEngine.Create(40000);
  FScript := TJSScript.Create;

  FEngine.Global.AddNativeObject(Edit1, 'edit');
  FEngine.Global.AddNativeObject(Button1, 'button');

  FScript.LoadRaw('script.js'); // Load the javascript code from file
  FScript.Execute(FEngine);     // Register the function with the JS engine
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  FEngine.Free;
  FScript.Free;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  FEngine.Global.Evaluate('toggle()');
end;

end.
